<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="utf-8"/>

<xsl:template match="/MEREPORT">
	<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
		<head>
			<title>Groups</title>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
			<link rel="stylesheet" type="text/css">
				<xsl:attribute name="href">
					<xsl:value-of select="csspath"/>
				</xsl:attribute>
			</link>
		</head>
		<body>
			<div id="content">		
				<h1>Groups</h1>
				<xsl:call-template name="groups"/>
			</div>
		</body>
	</html>
</xsl:template>

<xsl:template name="groups">
	<table>
		<tr>
			<th>id</th>
			<th>name</th>
			<th>notes</th>
		</tr>
		
		<xsl:for-each select="group">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="@id"/></td>
				<td><xsl:value-of select="@name"/></td>
				<td><xsl:value-of select="@notes"/></td>
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

</xsl:stylesheet>

